<?php
session_start();
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require '../backend/db.php';
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $stmt = $conn->prepare('SELECT id, username, password FROM admins WHERE username=? LIMIT 1');
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $row['username'];
            header('Location: admin_dashboard.php');
            exit;
        } else {
            $error = 'Invalid admin credentials.';
        }
    } else {
        $error = 'Admin user not found.';
    }
    $stmt->close();
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Chicken Road</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body { background: #232834; margin: 0; }
        .login-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .login-box {
            background: #2c3240;
            border-radius: 12px;
            box-shadow: 0 4px 24px #0003;
            padding: 36px 32px 28px 32px;
            min-width: 320px;
        }
        .login-title {
            font-size: 2rem;
            color: #ffe066;
            font-weight: bold;
            margin-bottom: 18px;
            text-align: center;
        }
        .login-form label {
            color: #fff;
            font-size: 1.1rem;
            font-weight: 500;
        }
        .login-form input {
            width: 100%;
            padding: 10px 12px;
            margin: 8px 0 18px 0;
            border-radius: 6px;
            border: none;
            background: #383f4e;
            color: #fff;
            font-size: 1rem;
        }
        .login-btn {
            width: 100%;
            background: #e11d48;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 0;
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.2s;
        }
        .login-btn:hover { background: #b91c1c; }
        .login-error {
            color: #e11d48;
            font-weight: 600;
            margin-bottom: 10px;
            text-align: center;
        }
        .admin-links {
            margin-top: 16px;
            display: flex;
            flex-direction: column;
            gap: 8px;
            align-items: center;
        }
        .admin-link {
            color: #ffe066;
            text-decoration: underline;
            font-size: 1rem;
            cursor: pointer;
            transition: color 0.2s;
        }
        .admin-link:hover { color: #fff; }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <div class="login-title">Admin Login</div>
            <?php if ($error): ?>
                <div class="login-error"><?php echo $error; ?></div>
            <?php endif; ?>
            <form class="login-form" method="post" autocomplete="off">
                <label for="username">Admin Username</label>
                <input type="text" id="username" name="username" required autofocus>
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
                <button class="login-btn" type="submit">Login</button>
            </form>
            <div class="admin-links">
                <a class="admin-link" href="admin_register.php">Register new admin</a>
            </div>
        </div>
    </div>
</body>
</html> 